(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     12702,        318]
NotebookOptionsPosition[     12387,        302]
NotebookOutlinePosition[     12744,        318]
CellTagsIndexPosition[     12701,        315]
WindowFrame->Palette*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 DynamicModuleBox[{$CellContext`type$$ = 
  "Application", $CellContext`source$$ = "", $CellContext`loc$$ = 
  FrontEnd`FileName[{FrontEnd`$UserBaseDirectory}], $CellContext`name$$ = ""}, 
  PanelBox[
   TagBox[GridBox[{
      {
       StyleBox["\<\"Geometric Optics installation panel\"\>", "Text",
        StripOnInput->False,
        FontWeight->Bold]},
      {"\<\"Select source archive\"\>"},
      {
       ButtonBox["\<\"Browse...\"\>",
        Appearance->Automatic,
        ButtonFunction:>($CellContext`source$$ = 
         SystemDialogInput["FileOpen", {"", 
            FrontEndResource["FEStrings", 
             StringJoin["install", 
              Last[
               StringSplit[$CellContext`type$$]], "Filter"]]}, WindowTitle -> 
           " "]),
        Evaluator->Automatic,
        ImageSize->Automatic,
        Method->"Queued"]},
      {
       TagBox[GridBox[{
          {"\<\"Selected source archive:\"\>"},
          {
           InterpretationBox[
            StyleBox[
             GraphicsBox[{},
              BaselinePosition->Baseline,
              ImageSize->{3, 0}],
             CacheGraphics->False],
            Spacer[3]]},
          {
           DynamicBox[ToBoxes[
             If[$CellContext`source$$ === "", 
              Style["None", Gray, FontSlant -> Italic], 
              Tooltip[
               FileBaseName[$CellContext`source$$], $CellContext`source$$]], 
             StandardForm],
            ImageSizeCache->{28., {0., 9.}}]}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Center}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]},
      {
       InterpretationBox[
        StyleBox[GridBox[{
           {GridBox[{
              {
               
               RadioButtonBox[Dynamic[$CellContext`loc$$], {
                FrontEnd`FileName[{FrontEnd`$UserBaseDirectory}]},
                DefaultBaseStyle->"RadioButtonBar"], 
               StyleBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   
                   DynamicBox[FEPrivate`FrontEndResource[
                    "FEStrings", "installUserBaseDir"],
                    ImageSizeCache->{173., {3., 12.}}],
                   
                   "\"C:\\\\Users\\\\roberto\\\\AppData\\\\Roaming\\\\\
Mathematica\\\\Applications\\\\\"",
                   TooltipDelay->Automatic,
                   TooltipStyle->"TextStyling"],
                  
                  Annotation[#, 
                   "C:\\Users\\roberto\\AppData\\Roaming\\Mathematica\\\
Applications\\", "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseDown" :> ($CellContext`loc$$ = 
                    FrontEnd`FileName[{FrontEnd`$UserBaseDirectory}]), Method -> 
                   "Preemptive", PassEventsDown -> Automatic, PassEventsUp -> 
                   True}]], "RadioButtonBarLabel",
                StripOnInput->False]}
             },
             AutoDelete->False,
             
             GridBoxAlignment->{
              "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.21]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]},
           {GridBox[{
              {
               
               RadioButtonBox[Dynamic[$CellContext`loc$$], {
                FrontEnd`FileName[{FrontEnd`$BaseDirectory}]},
                DefaultBaseStyle->"RadioButtonBar"], 
               StyleBox[
                TagBox[
                 TagBox[
                  
                  TooltipBox["\<\"Install for all users that share this \
computer\"\>",
                   "\"C:\\\\ProgramData\\\\Mathematica\\\\Applications\\\\\"",
                   TooltipDelay->Automatic,
                   TooltipStyle->"TextStyling"],
                  
                  Annotation[#, 
                   "C:\\ProgramData\\Mathematica\\Applications\\", 
                   "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseDown" :> ($CellContext`loc$$ = 
                    FrontEnd`FileName[{FrontEnd`$BaseDirectory}]), Method -> 
                   "Preemptive", PassEventsDown -> Automatic, PassEventsUp -> 
                   True}]], "RadioButtonBarLabel",
                StripOnInput->False]}
             },
             AutoDelete->False,
             
             GridBoxAlignment->{
              "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.21]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], "Deploy"],
        RadioButtonBar[
         Dynamic[$CellContext`loc$$], {
         FrontEnd`FileName[{FrontEnd`$UserBaseDirectory}] -> EventHandler[
            Tooltip[
             Dynamic[
              RawBoxes[
               FEPrivate`FrontEndResource[
               "FEStrings", "installUserBaseDir"]]], 
             "C:\\Users\\roberto\\AppData\\Roaming\\Mathematica\\Applications\
\\", TooltipDelay -> Automatic], 
            "MouseDown" :> ($CellContext`loc$$ = 
             FrontEnd`FileName[{FrontEnd`$UserBaseDirectory}])], 
          FrontEnd`FileName[{FrontEnd`$BaseDirectory}] -> EventHandler[
            Tooltip[
            "Install for all users that share this computer", 
             "C:\\ProgramData\\Mathematica\\Applications\\", TooltipDelay -> 
             Automatic], 
            "MouseDown" :> ($CellContext`loc$$ = 
             FrontEnd`FileName[{FrontEnd`$BaseDirectory}])]}, Appearance -> 
         "Vertical"]]},
      {
       DynamicModuleBox[{$CellContext`dialog$$, $CellContext`copyfiles$$, \
$CellContext`installDir$$, $CellContext`removepreexisting$$, \
$CellContext`newfiles$$}, 
        TemplateBox[{ButtonBox["\"Ok\"", ButtonFunction :> (If[
              
              DirectoryQ[$CellContext`source$$], $CellContext`installDir$$ = 
               ToFileName[{$CellContext`loc$$, "Applications", 
                  FileBaseName[$CellContext`source$$]}]; 
              CopyDirectory[$CellContext`source$$, \
$CellContext`installDir$$], $CellContext`newfiles$$ = 
               Import[$CellContext`source$$, 
                 "FileNames"]; $CellContext`installDir$$ = 
               ToFileName[{$CellContext`loc$$, 
                  "Applications"}]; $CellContext`removepreexisting$$[
                Union[
                 Map[ToFileName[{$CellContext`installDir$$, 
                    
                    FileNameTake[#, 
                    1]}]& , $CellContext`newfiles$$]]]; \
$CellContext`copyfiles$$[$CellContext`source$$, $CellContext`installDir$$, \
$CellContext`newfiles$$]]; DialogReturn[]), ImageSize -> 65, Enabled -> 
           Dynamic[
             If[$CellContext`source$$ =!= $Canceled, 
              Or[
               Quiet[
                DirectoryQ[$CellContext`source$$]], 
               StringMatchQ[$CellContext`source$$, 
                Alternatives["*.zip", "*.gz", "*.tar", "*.bz2"]]], False]], 
           Method -> "Queued", Evaluator -> Automatic, Appearance -> 
           Automatic],ButtonBox[
          "\"Cancel\"", ButtonFunction :> DialogReturn[$Canceled], ImageSize -> 
           Full, Appearance -> Automatic, Evaluator -> Automatic, Method -> 
           "Preemptive"]},
         "RowDefault"],
        DynamicModuleValues:>{{
          DownValues[$CellContext`copyfiles$$] = {HoldPattern[
               $CellContext`copyfiles$$[
                PatternTest[
                 Pattern[$CellContext`sourcepath$, 
                  Blank[]], StringMatchQ[#, 
                  Alternatives["*.zip", "*.gz", "*.tar", "*.bz2"]]& ], 
                Pattern[$CellContext`outputDir$, 
                 Blank[]], 
                Pattern[$CellContext`installfiles$, 
                 Blank[]]]] :> 
             DynamicModule[{$CellContext`tempdir = CreateDirectory[]}, 
               ExtractArchive[$CellContext`sourcepath$, $CellContext`tempdir]; \
$CellContext`copyfiles$$[$CellContext`tempdir, $CellContext`outputDir$, \
$CellContext`installfiles$]; 
               DeleteDirectory[$CellContext`tempdir, DeleteContents -> True]],
              HoldPattern[
               $CellContext`copyfiles$$[
                Pattern[$CellContext`sourcepath$, 
                 Blank[]], 
                Pattern[$CellContext`outputDir$, 
                 Blank[]], 
                Pattern[$CellContext`installfiles$, 
                 Blank[]]]] :> 
             DynamicModule[{}, SetDirectory[$CellContext`outputDir$]; Scan[If[
                  Not[
                   DirectoryQ[#]], 
                  CreateDirectory[#]]& , 
                 DeleteCases[
                  Union[
                   Map[DirectoryName, $CellContext`installfiles$]], 
                  ""]]; $CellContext`dialog$$ = CreateDialog[
                  Grid[{{
                    Dynamic[
                    RawBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "installExtractFrom"]]], 
                    " : ", $CellContext`sourcepath$}, {
                    Dynamic[
                    RawBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "installExtractTo"]]], " : ", 
                    Directory[]}, {
                    ProgressIndicator[
                    Dynamic[
                    Clock[]], Indeterminate, ImageSize -> 300], 
                    SpanFromLeft}, {
                    Pane[
                    Dynamic[$CellContext`name$$], {300, 50}], SpanFromLeft}}, 
                   Alignment -> Left, Spacings -> {Automatic, 2}], 
                  WindowTitle -> Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "installExtractTitle"]], Modal -> True, 
                  NotebookEventActions -> {}]; 
               Scan[Export[$CellContext`name$$ = #, 
                  Import[$CellContext`sourcepath$, {#, "String"}], 
                  "String"]& , $CellContext`installfiles$]; 
               NotebookClose[$CellContext`dialog$$]; ResetDirectory[]]}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{35}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{2}}}],
    "Column"]],
  Editable -> False,
  Saveable -> False,
  DynamicModuleValues:>{}]],
 CellMargins->{{0, 0}, {0, 0}},
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellHorizontalScrolling->True,
 PageBreakAbove->True,
 PageBreakWithin->False,
 ShowAutoStyles->True,
 LineSpacing->{1.25, 0},
 AutoItalicWords->{},
 ScriptMinSize->9,
 ShowStringCharacters->False,
 FontFamily:>CurrentValue["PanelFontFamily"],
 FontSize:>CurrentValue["PanelFontSize"]]
},
WindowSize->All,
WindowMargins->{{Automatic, 381}, {Automatic, 151}},
WindowElements->{},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Palette.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[559, 20, 11824, 280, 302, InheritFromParent,
 PageBreakAbove->True,
 PageBreakWithin->False]
}
]
*)

(* End of internal cache information *)

